/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.List;
import java.util.Set;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import lotr.common.dispenser.LOTRDispenseSpear;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.entity.projectile.LOTREntitySpear;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRItemSword;
import lotr.common.item.LOTRMaterial;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class LOTRItemSpear
extends LOTRItemSword {
    public LOTRItemSpear(LOTRMaterial material) {
        this(material.toToolMaterial());
    }

    public LOTRItemSpear(Item.ToolMaterial material) {
        super(material);
        this.lotrWeaponDamage -= 1.0f;
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new LOTRDispenseSpear());
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityplayer, int useDuration) {
        if (entityplayer.func_70694_bm() != itemstack) {
            return;
        }
        int useTick = this.func_77626_a(itemstack) - useDuration;
        if (useTick < 10) {
            return;
        }
        float charge = (float)(useTick -= 10) / (float)this.getMaxDrawTime();
        if (charge < 0.1f) {
            return;
        }
        charge = (charge * charge + charge * 2.0f) / 3.0f;
        charge = Math.min(charge, 1.0f);
        LOTREntitySpear spear = new LOTREntitySpear(world, (EntityLivingBase)entityplayer, itemstack.func_77946_l(), charge * 2.0f);
        if (charge >= 1.0f) {
            spear.setIsCritical(true);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)itemstack) + LOTREnchantmentHelper.calcFireAspect(itemstack) > 0) {
            spear.func_70015_d(100);
        }
        for (LOTREnchantment ench : LOTREnchantment.allEnchantments) {
            if (!ench.applyToProjectile() || !LOTREnchantmentHelper.hasEnchant(itemstack, ench)) continue;
            LOTREnchantmentHelper.setProjectileEnchantment(spear, ench);
        }
        if (entityplayer.field_71075_bZ.field_75098_d) {
            spear.canBePickedUp = 2;
        }
        world.func_72956_a((Entity)entityplayer, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + charge * 0.5f);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)spear);
        }
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
            if (itemstack.field_77994_a <= 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
        }
    }

    public int getMaxDrawTime() {
        return 20;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (player != null) {
            String factionName;
            int reputation;
            LOTRPlayerData playerData = LOTRLevelData.getData(player);
            LOTRFaction pledgeFaction = playerData.getPledgeFaction();
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_TREE) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else if (reputation >= 10000 && reputation < 15000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 20000}));
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.entDamage.active", (Object[])new Object[]{"3.0"}));
                } else if (reputation >= 20000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.active", (Object[])new Object[]{"2.0"}));
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.entDamage.active", (Object[])new Object[]{"3.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_TROLL) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                list.add(EnumChatFormatting.GREEN + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                if (reputation < 20000) {
                    list.add("");
                    list.add(EnumChatFormatting.GREEN + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 20000}));
                } else {
                    list.add("");
                    list.add(EnumChatFormatting.GREEN + "\u2694 " + I18n.func_135052_a((String)"item.hammer.trollDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_DWARF) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.dwarfDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_ORC) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_MAN) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 5000) {
                    list.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 5000}));
                } else {
                    list.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.manDamage.active", (Object[])new Object[]{"3.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_ELF) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 15000) {
                    list.add(EnumChatFormatting.AQUA + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GREEN + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 15000}));
                } else {
                    list.add(EnumChatFormatting.GREEN + "\u2694 " + I18n.func_135052_a((String)"item.hammer.elfDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
        }
    }

    private LOTRFaction.FactionType getPriorityFactionType(Set<LOTRFaction.FactionType> factionTypes) {
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ELF)) {
            return LOTRFaction.FactionType.TYPE_ELF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_DWARF)) {
            return LOTRFaction.FactionType.TYPE_DWARF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TREE)) {
            return LOTRFaction.FactionType.TYPE_TREE;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_MAN)) {
            return LOTRFaction.FactionType.TYPE_MAN;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ORC)) {
            return LOTRFaction.FactionType.TYPE_ORC;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TROLL)) {
            return LOTRFaction.FactionType.TYPE_TROLL;
        }
        return LOTRFaction.FactionType.TYPE_FREE;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 72000;
    }

    public float getRangedDamageMultiplier(ItemStack itemstack, Entity shooter, Entity hit) {
        float damage = this.getLOTRWeaponDamage();
        damage = shooter instanceof EntityLivingBase && hit instanceof EntityLivingBase ? (damage = damage + EnchantmentHelper.func_77512_a((EntityLivingBase)((EntityLivingBase)shooter), (EntityLivingBase)((EntityLivingBase)hit))) : (damage = damage + EnchantmentHelper.func_152377_a((ItemStack)itemstack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED));
        return damage * 0.7f;
    }
}

